﻿
/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

using System.Data;

//access resource.resx
using System.Resources;

//our data access class library
using DataAccess;

/// <summary>
/// Summary description for CClinic
/// </summary>
public class CClinicDataXfer: CData
{
    /// <summary>
    /// US:6048 constructor
    /// </summary>
    /// <param name="data"></param>
    public CClinicDataXfer(CData data)
        : base(data)
	{
        //constructors are not inherited in c#!
	}

    /// <summary>
    ///  US:6048 saves a Clinic to the database
    /// </summary>
    /// <param name="lXferSystemID"></param>
    /// <param name="lTeamID"></param>
    /// <param name="strTeamLabel"></param>
    /// <returns></returns>
    public CStatus SaveClinic(long lXferSystemID,
                              long lClinicID,
                              string strClinicLabel)
    {
        CStatus status = new CStatus();

        //load the paramaters list
        CDataParameterList pList = new CDataParameterList(base.SessionID,
                                                  base.ClientIP,
                                                  base.UserID);

        pList.AddInputParameter("pi_nXferSystemID", lXferSystemID);
        pList.AddInputParameter("pi_nRegionID", this.RegionID);
        pList.AddInputParameter("pi_nSiteID", this.SiteID);
        pList.AddInputParameter("pi_nClinicID", lClinicID);
        pList.AddInputParameter("pi_vClinicLabel", strClinicLabel);

        return DBConn.ExecuteOracleSP("PCK_XFER.XferClinic",
                                      pList);
    }

   
}
